#include <amxmodx>
#include <engine>
#include <umitem>

new PLUGIN_NAME[] 	= "UM Item: Bulls Eye"
new PLUGIN_AUTHOR[] 	= "Cheap_Suit"
new PLUGIN_VERSION[] 	= "1.0"


new bool:Zooming[33]
new g_LastWeapon[33]
new Float:g_Delay[33]
new bool:g_Bullseye[33] 
public plugin_init() 
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR)
	register_event("CurWeapon", "Event_CurWeapon", "be", "1=1")
	register_event("DeathMsg", "Event_DeathMsg", "a")
	register_item("Bulls Eye", "Zoom for any weapon", 1900)
}

public plugin_precache() {
	precache_sound("weapons/zoom.wav")
}

public client_connect(id) {
	g_Bullseye[id] = false
}

public Event_DeathMsg() { 
	Message_Zoom(read_data(2), 90)
}

public Enable_Item(id) {
	g_Bullseye[id] = true
}

public Disable_Item(id) {
	g_Bullseye[id] = false
}

public Event_CurWeapon(id)
{
	if(!is_user_connected(id) || !is_user_alive(id)) {
		return PLUGIN_CONTINUE
	}
	
	if(!g_Bullseye[id]) {
		return PLUGIN_CONTINUE
	}
	
	new Weapon_ID = read_data(2)
	new Weapon_Clip = read_data(3)
	
	if(g_LastWeapon[id] != Weapon_ID)
	{
		g_LastWeapon[id] = Weapon_ID
		if(Zooming[id])
		{
			Zooming[id] = false
			Message_Zoom(id, 90)
		}
	}
	
	if(Weapon_Clip == 0 && Zooming[id])
	{
		Zooming[id] = false
		Message_Zoom(id, 90)
	}
	
	return PLUGIN_CONTINUE
}

public client_PreThink(id)
{
	if(!is_user_connected(id) || !is_user_alive(id)) {
		return PLUGIN_CONTINUE
	}
	
	if(!g_Bullseye[id]) {
		return PLUGIN_CONTINUE
	}
		
	new clip, ammo, weapon = get_user_weapon(id, clip, ammo)
	if(weapon == CSW_AWP || weapon == CSW_SCOUT || weapon == CSW_SG552 || weapon == CSW_G3SG1 || weapon == CSW_AUG || weapon == CSW_SG550 
	|| weapon == CSW_KNIFE || weapon == CSW_C4 || weapon == CSW_HEGRENADE || weapon == CSW_FLASHBANG || weapon == CSW_SMOKEGRENADE ) {
		return PLUGIN_CONTINUE
	}
		
	if(get_user_button(id) & IN_RELOAD && CheckMaxAmmo(id) && Zooming[id]) 
	{
		Zooming[id] = false
		Message_Zoom(id, 90)
	}
		
	if(get_user_button(id) & IN_ATTACK2)
	{
		if((g_Delay[id] + 1.8) < get_gametime())
		{
			if(!Zooming[id]) 
			{
				Zooming[id] = true
				Message_Zoom(id, 40)
			} 
			else 
			{
				Zooming[id] = false
				Message_Zoom(id, 90)	
			}
			emit_sound(id, CHAN_WEAPON, "weapons/zoom.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
			g_Delay[id] = get_gametime()
		}
	}
	return PLUGIN_CONTINUE
}
	
Message_Zoom(id, value)
{
	message_begin(MSG_ONE, get_user_msgid("SetFOV"), {0, 0, 0}, id)
	write_byte(value)
	message_end()
}

CheckMaxAmmo(id)
{ 
	new clip,temp, wpn_id = get_user_weapon(id, clip, temp)
	switch(wpn_id) 
	{ 
		case CSW_M3:		if(clip != 8)	return true 
		case CSW_XM1014:	if(clip != 7)	return true 
		case CSW_MP5NAVY:	if(clip != 30)	return true 
		case CSW_TMP:		if(clip != 30)	return true 
		case CSW_P90:		if(clip != 50)	return true 
		case CSW_MAC10:		if(clip != 30)	return true 
		case CSW_UMP45:		if(clip != 25)	return true 
		case CSW_AK47:		if(clip != 30)	return true 
		case CSW_SG552:		if(clip != 30)	return true 
		case CSW_M4A1:		if(clip != 30)	return true 
		case CSW_AUG:		if(clip != 30)	return true 
		case CSW_SCOUT:		if(clip != 10)	return true 
		case CSW_AWP:		if(clip != 10)	return true 
		case CSW_G3SG1:		if(clip != 20)	return true 
		case CSW_SG550:		if(clip != 30)	return true 
		case CSW_M249:		if(clip != 100)	return true 
		case CSW_USP:		if(clip != 12)	return true 
		case CSW_GLOCK18:	if(clip != 20)	return true 
		case CSW_DEAGLE:	if(clip != 7)	return true 
		case CSW_P228:		if(clip != 13)	return true 
		case CSW_ELITE:		if(clip != 30)	return true 
		case CSW_FIVESEVEN:	if(clip != 20)	return true 
		case CSW_GALIL:		if(clip != 35)	return true 
		case CSW_FAMAS:		if(clip != 25)	return true 
	}
	return false 
} 
